<?php
/**
 * Admin Tools Page Template
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="cpwa-tools-container" style="max-width: 900px;">
        
        <!-- Test PWA Features -->
        <div class="cpwa-tools-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
            <h2><?php esc_html_e('Test PWA Features', 'custom-pwa-installer'); ?></h2>
            
            <table class="form-table" role="presentation">
                <tbody>
                    <tr>
                        <th scope="row"><?php esc_html_e('Manifest Test', 'custom-pwa-installer'); ?></th>
                        <td>
                            <a href="<?php echo esc_url(home_url('/pwa-manifest.json')); ?>" target="_blank" class="button">
                                <?php esc_html_e('View Manifest', 'custom-pwa-installer'); ?>
                            </a>
                            <p class="description"><?php esc_html_e('Open manifest.json in a new tab to verify it loads correctly', 'custom-pwa-installer'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row"><?php esc_html_e('Service Worker Test', 'custom-pwa-installer'); ?></th>
                        <td>
                            <a href="<?php echo esc_url(home_url('/sw.js')); ?>" target="_blank" class="button">
                                <?php esc_html_e('View Service Worker', 'custom-pwa-installer'); ?>
                            </a>
                            <p class="description"><?php esc_html_e('Open service worker script in a new tab to verify it loads', 'custom-pwa-installer'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row"><?php esc_html_e('Offline Page Test', 'custom-pwa-installer'); ?></th>
                        <td>
                            <a href="<?php echo esc_url(home_url('/offline.html')); ?>" target="_blank" class="button">
                                <?php esc_html_e('View Offline Page', 'custom-pwa-installer'); ?>
                            </a>
                            <p class="description"><?php esc_html_e('Open offline fallback page to verify it displays correctly', 'custom-pwa-installer'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row"><?php esc_html_e('Frontend Test', 'custom-pwa-installer'); ?></th>
                        <td>
                            <a href="<?php echo esc_url(home_url('/')); ?>" target="_blank" class="button button-primary">
                                <?php esc_html_e('Open Homepage', 'custom-pwa-installer'); ?>
                            </a>
                            <p class="description"><?php esc_html_e('Open your homepage to test the install button (press F12 to open DevTools)', 'custom-pwa-installer'); ?></p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <!-- Diagnostic Information -->
        <div class="cpwa-tools-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
            <h2><?php esc_html_e('Diagnostic Information', 'custom-pwa-installer'); ?></h2>
            
            <table class="widefat" style="margin-top: 10px;">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Check', 'custom-pwa-installer'); ?></th>
                        <th><?php esc_html_e('Status', 'custom-pwa-installer'); ?></th>
                        <th><?php esc_html_e('Details', 'custom-pwa-installer'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><strong><?php esc_html_e('HTTPS', 'custom-pwa-installer'); ?></strong></td>
                        <td>
                            <?php if (is_ssl()) : ?>
                                <span style="color: #46b450;">✓ <?php esc_html_e('Enabled', 'custom-pwa-installer'); ?></span>
                            <?php else : ?>
                                <span style="color: #dc3232;">✗ <?php esc_html_e('Disabled', 'custom-pwa-installer'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if (is_ssl()) : ?>
                                <?php esc_html_e('PWA features will work', 'custom-pwa-installer'); ?>
                            <?php else : ?>
                                <?php esc_html_e('HTTPS required for PWA (except localhost)', 'custom-pwa-installer'); ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    
                    <tr>
                        <td><strong><?php esc_html_e('App Name', 'custom-pwa-installer'); ?></strong></td>
                        <td>
                            <?php if (get_option('cpwa_app_name')) : ?>
                                <span style="color: #46b450;">✓ <?php esc_html_e('Set', 'custom-pwa-installer'); ?></span>
                            <?php else : ?>
                                <span style="color: #f0ad4e;">⚠ <?php esc_html_e('Using default', 'custom-pwa-installer'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo esc_html(get_option('cpwa_app_name', get_bloginfo('name'))); ?></td>
                    </tr>
                    
                    <tr>
                        <td><strong><?php esc_html_e('Icons', 'custom-pwa-installer'); ?></strong></td>
                        <td>
                            <?php if (get_option('cpwa_icon_192') && get_option('cpwa_icon_512')) : ?>
                                <span style="color: #46b450;">✓ <?php esc_html_e('Uploaded', 'custom-pwa-installer'); ?></span>
                            <?php else : ?>
                                <span style="color: #f0ad4e;">⚠ <?php esc_html_e('Using default', 'custom-pwa-installer'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if (get_option('cpwa_icon_192') && get_option('cpwa_icon_512')) : ?>
                                <?php esc_html_e('Custom icons uploaded', 'custom-pwa-installer'); ?>
                            <?php else : ?>
                                <?php esc_html_e('Upload icons in Settings for better branding', 'custom-pwa-installer'); ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    
                    <tr>
                        <td><strong><?php esc_html_e('Install Button', 'custom-pwa-installer'); ?></strong></td>
                        <td>
                            <?php if (get_option('cpwa_show_install_button', true)) : ?>
                                <span style="color: #46b450;">✓ <?php esc_html_e('Enabled', 'custom-pwa-installer'); ?></span>
                            <?php else : ?>
                                <span style="color: #dc3232;">✗ <?php esc_html_e('Disabled', 'custom-pwa-installer'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if (get_option('cpwa_show_install_button', true)) : ?>
                                <?php esc_html_e('Button will show on frontend when installable', 'custom-pwa-installer'); ?>
                            <?php else : ?>
                                <?php esc_html_e('Enable in Settings to show install button', 'custom-pwa-installer'); ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    
                    <tr>
                        <td><strong><?php esc_html_e('WordPress Version', 'custom-pwa-installer'); ?></strong></td>
                        <td>
                            <?php if (version_compare(get_bloginfo('version'), '5.0', '>=')) : ?>
                                <span style="color: #46b450;">✓ <?php esc_html_e('Compatible', 'custom-pwa-installer'); ?></span>
                            <?php else : ?>
                                <span style="color: #dc3232;">✗ <?php esc_html_e('Update needed', 'custom-pwa-installer'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo esc_html(get_bloginfo('version')); ?></td>
                    </tr>
                    
                    <tr>
                        <td><strong><?php esc_html_e('PHP Version', 'custom-pwa-installer'); ?></strong></td>
                        <td>
                            <?php if (version_compare(PHP_VERSION, '7.2', '>=')) : ?>
                                <span style="color: #46b450;">✓ <?php esc_html_e('Compatible', 'custom-pwa-installer'); ?></span>
                            <?php else : ?>
                                <span style="color: #dc3232;">✗ <?php esc_html_e('Update needed', 'custom-pwa-installer'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo esc_html(PHP_VERSION); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <!-- Quick Actions -->
        <div class="cpwa-tools-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
            <h2><?php esc_html_e('Quick Actions', 'custom-pwa-installer'); ?></h2>
            
            <form method="post" action="">
                <?php wp_nonce_field('cpwa_tools_nonce', 'cpwa_tools_nonce_field'); ?>
                
                <p>
                    <a href="<?php echo esc_url(admin_url('options-permalink.php')); ?>" class="button button-primary">
                        <?php esc_html_e('Flush Permalinks', 'custom-pwa-installer'); ?>
                    </a>
                    <span class="description"><?php esc_html_e('Click "Save Changes" on Permalinks page to flush rewrite rules', 'custom-pwa-installer'); ?></span>
                </p>
                
                <p style="margin-top: 15px;">
                    <button type="submit" name="cpwa_clear_cache" class="button">
                        <?php esc_html_e('Clear Service Worker Cache', 'custom-pwa-installer'); ?>
                    </button>
                    <span class="description"><?php esc_html_e('Sends instruction to clear all PWA cached data (requires page reload on frontend)', 'custom-pwa-installer'); ?></span>
                </p>
            </form>
        </div>
        
        <!-- Chrome DevTools Guide -->
        <div class="cpwa-tools-section" style="background: #e7f3ff; padding: 20px; margin-top: 20px; border-left: 4px solid #2271b1;">
            <h3><?php esc_html_e('Testing with Chrome DevTools', 'custom-pwa-installer'); ?></h3>
            <ol style="line-height: 1.8;">
                <li><?php esc_html_e('Open your website in Chrome', 'custom-pwa-installer'); ?></li>
                <li><?php esc_html_e('Press F12 to open DevTools', 'custom-pwa-installer'); ?></li>
                <li><?php esc_html_e('Go to "Application" tab', 'custom-pwa-installer'); ?></li>
                <li><?php esc_html_e('Check "Manifest" section - verify all fields are populated', 'custom-pwa-installer'); ?></li>
                <li><?php esc_html_e('Check "Service Workers" section - should show "activated and running"', 'custom-pwa-installer'); ?></li>
                <li><?php esc_html_e('Go to "Lighthouse" tab and run a PWA audit', 'custom-pwa-installer'); ?></li>
            </ol>
        </div>
        
    </div>
</div>


