<?php
/**
 * Admin Settings Page Template
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <?php
    // Check if HTTPS is enabled
    if (!is_ssl()) {
        ?>
        <div class="notice notice-warning">
            <p><strong><?php esc_html_e('Warning:', 'custom-pwa-installer'); ?></strong> 
            <?php esc_html_e('Your site is not using HTTPS. PWA features require a secure connection (HTTPS) to work properly.', 'custom-pwa-installer'); ?>
            </p>
        </div>
        <?php
    }
    ?>
    
    <div class="cpwa-admin-container" style="max-width: 900px;">
        <form method="post" action="options.php">
            <?php
            settings_fields('cpwa_settings');
            wp_nonce_field('cpwa_settings_nonce', 'cpwa_settings_nonce_field');
            ?>
            
            <div class="cpwa-settings-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
                <h2><?php esc_html_e('General Settings', 'custom-pwa-installer'); ?></h2>
                
                <table class="form-table" role="presentation">
                    <tbody>
                        <tr>
                            <th scope="row">
                                <label for="cpwa_app_name"><?php esc_html_e('App Name', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_app_name" name="cpwa_app_name" value="<?php echo esc_attr(get_option('cpwa_app_name', get_bloginfo('name'))); ?>" class="regular-text">
                                <p class="description"><?php esc_html_e('Full name of your Progressive Web App (shown on splash screen)', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_short_name"><?php esc_html_e('Short Name', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_short_name" name="cpwa_short_name" value="<?php echo esc_attr(get_option('cpwa_short_name', get_bloginfo('name'))); ?>" class="regular-text">
                                <p class="description"><?php esc_html_e('Short name (shown under app icon, max 12 characters recommended)', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_description"><?php esc_html_e('Description', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <textarea id="cpwa_description" name="cpwa_description" rows="3" class="large-text"><?php echo esc_textarea(get_option('cpwa_description', get_bloginfo('description'))); ?></textarea>
                                <p class="description"><?php esc_html_e('Brief description of your app', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_start_url"><?php esc_html_e('Start URL', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="url" id="cpwa_start_url" name="cpwa_start_url" value="<?php echo esc_url(get_option('cpwa_start_url', home_url('/'))); ?>" class="regular-text">
                                <p class="description"><?php esc_html_e('URL to load when app is launched', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_theme_color"><?php esc_html_e('Theme Color', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_theme_color" name="cpwa_theme_color" value="<?php echo esc_attr(get_option('cpwa_theme_color', '#4285f4')); ?>" class="cpwa-color-picker">
                                <p class="description"><?php esc_html_e('Color for browser UI elements', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_background_color"><?php esc_html_e('Background Color', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_background_color" name="cpwa_background_color" value="<?php echo esc_attr(get_option('cpwa_background_color', '#ffffff')); ?>" class="cpwa-color-picker">
                                <p class="description"><?php esc_html_e('Background color for splash screen', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
            <div class="cpwa-settings-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
                <h2><?php esc_html_e('Install Button Settings', 'custom-pwa-installer'); ?></h2>
                
                <table class="form-table" role="presentation">
                    <tbody>
                        <tr>
                            <th scope="row">
                                <label for="cpwa_show_install_button"><?php esc_html_e('Show Install Button', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <label>
                                    <input type="checkbox" id="cpwa_show_install_button" name="cpwa_show_install_button" value="1" <?php checked(get_option('cpwa_show_install_button', true), 1); ?>>
                                    <?php esc_html_e('Display custom install button on frontend', 'custom-pwa-installer'); ?>
                                </label>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_debug_mode"><?php esc_html_e('Debug Mode', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <label>
                                    <input type="checkbox" id="cpwa_debug_mode" name="cpwa_debug_mode" value="1" <?php checked(get_option('cpwa_debug_mode', false), 1); ?>>
                                    <?php esc_html_e('Force show install button for testing (ignores PWA requirements)', 'custom-pwa-installer'); ?>
                                </label>
                                <p class="description" style="color: #f0ad4e;">
                                    <strong><?php esc_html_e('Warning:', 'custom-pwa-installer'); ?></strong> 
                                    <?php esc_html_e('Only enable for testing. Button will appear even if PWA is not installable. Disable in production!', 'custom-pwa-installer'); ?>
                                </p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_install_button_text"><?php esc_html_e('Install Button Text', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_install_button_text" name="cpwa_install_button_text" value="<?php echo esc_attr(get_option('cpwa_install_button_text', 'Install App')); ?>" class="regular-text">
                                <p class="description"><?php esc_html_e('Text displayed on the install button', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_installing_text"><?php esc_html_e('Installing Text', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_installing_text" name="cpwa_installing_text" value="<?php echo esc_attr(get_option('cpwa_installing_text', 'Installing...')); ?>" class="regular-text">
                                <p class="description"><?php esc_html_e('Text shown during installation', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_installed_text"><?php esc_html_e('Installed Text', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_installed_text" name="cpwa_installed_text" value="<?php echo esc_attr(get_option('cpwa_installed_text', 'App Installed!')); ?>" class="regular-text">
                                <p class="description"><?php esc_html_e('Success message after installation', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_popup_description"><?php esc_html_e('Popup Description', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <textarea id="cpwa_popup_description" name="cpwa_popup_description" rows="3" class="large-text"><?php echo esc_textarea(get_option('cpwa_popup_description', 'Install our app for a better experience. Get quick access and enjoy offline features.')); ?></textarea>
                                <p class="description"><?php esc_html_e('Description text shown in the install popup modal', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_ios_message"><?php esc_html_e('iOS Install Message', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <textarea id="cpwa_ios_message" name="cpwa_ios_message" rows="3" class="large-text"><?php echo esc_textarea(get_option('cpwa_ios_message', 'To install this app on your iPhone/iPad, tap the Share button and then "Add to Home Screen".')); ?></textarea>
                                <p class="description"><?php esc_html_e('Message shown to iOS Safari users (no beforeinstallprompt support)', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_popup_delay_days"><?php esc_html_e('Re-show Popup After', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <div style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
                                    <input type="number" id="cpwa_popup_delay_days" name="cpwa_popup_delay_days" value="<?php echo esc_attr(get_option('cpwa_popup_delay_days', 0)); ?>" min="0" max="365" class="small-text" style="width: 80px;">
                                    <label for="cpwa_popup_delay_days"><?php esc_html_e('days', 'custom-pwa-installer'); ?></label>
                                    
                                    <input type="number" id="cpwa_popup_delay_hours" name="cpwa_popup_delay_hours" value="<?php echo esc_attr(get_option('cpwa_popup_delay_hours', 0)); ?>" min="0" max="23" class="small-text" style="width: 80px;">
                                    <label for="cpwa_popup_delay_hours"><?php esc_html_e('hours', 'custom-pwa-installer'); ?></label>
                                    
                                    <input type="number" id="cpwa_popup_delay_minutes" name="cpwa_popup_delay_minutes" value="<?php echo esc_attr(get_option('cpwa_popup_delay_minutes', 0)); ?>" min="0" max="59" class="small-text" style="width: 80px;">
                                    <label for="cpwa_popup_delay_minutes"><?php esc_html_e('minutes', 'custom-pwa-installer'); ?></label>
                                </div>
                                <p class="description" style="margin-top: 10px;">
                                    <?php esc_html_e('When users close the install popup, wait this amount of time before showing it again. You can set days, hours, and/or minutes. At least one value must be greater than 0.', 'custom-pwa-installer'); ?>
                                    <br>
                                    <strong><?php esc_html_e('Examples:', 'custom-pwa-installer'); ?></strong>
                                    <?php esc_html_e('1 day', 'custom-pwa-installer'); ?>, 
                                    <?php esc_html_e('2 hours 30 minutes', 'custom-pwa-installer'); ?>, 
                                    <?php esc_html_e('0 days 0 hours 30 minutes', 'custom-pwa-installer'); ?>
                                </p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
            <div class="cpwa-settings-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
                <h2><?php esc_html_e('Popup Appearance', 'custom-pwa-installer'); ?></h2>
                
                <!-- Live Preview Section -->
                <div id="cpwa-live-preview" style="background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 20px; border: 2px dashed #dee2e6;">
                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                        <p style="margin: 0; font-weight: 600; color: #495057;">
                            <?php esc_html_e('Live Preview', 'custom-pwa-installer'); ?>
                        </p>
                        <button type="button" id="cpwa-show-popup-preview" class="button button-secondary" style="margin: 0;">
                            <?php esc_html_e('Show Popup Preview', 'custom-pwa-installer'); ?>
                        </button>
                    </div>
                    <div id="cpwa-preview-container" style="position: relative; max-width: 400px; margin: 0 auto; min-height: 200px;">
                        <!-- Preview will be rendered here -->
                    </div>
                    <div id="cpwa-popup-preview-overlay" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; z-index: 999999; background: rgba(0,0,0,0.5); align-items: center; justify-content: center;">
                        <div id="cpwa-popup-preview-content" style="position: relative; max-width: 90%; max-height: 90%; overflow: auto;">
                            <!-- Popup preview will be loaded here via AJAX -->
                        </div>
                    </div>
                </div>
                
                <table class="form-table" role="presentation">
                    <tbody>
                        <tr>
                            <th scope="row">
                                <label for="cpwa_popup_background_color"><?php esc_html_e('Popup Background', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_popup_background_color" name="cpwa_popup_background_color" value="<?php echo esc_attr(get_option('cpwa_popup_background_color', '#ffffff')); ?>" class="cpwa-color-picker" data-preview="background">
                                <p class="description"><?php esc_html_e('Background color of the popup modal', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_popup_text_color"><?php esc_html_e('Text Color', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_popup_text_color" name="cpwa_popup_text_color" value="<?php echo esc_attr(get_option('cpwa_popup_text_color', '#333333')); ?>" class="cpwa-color-picker" data-preview="text">
                                <p class="description"><?php esc_html_e('Color of title and description text', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_popup_button_color"><?php esc_html_e('Button Background', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_popup_button_color" name="cpwa_popup_button_color" value="<?php echo esc_attr(get_option('cpwa_popup_button_color', '#667eea')); ?>" class="cpwa-color-picker" data-preview="button-bg">
                                <p class="description"><?php esc_html_e('Background color of the install button', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_popup_button_text_color"><?php esc_html_e('Button Text Color', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_popup_button_text_color" name="cpwa_popup_button_text_color" value="<?php echo esc_attr(get_option('cpwa_popup_button_text_color', '#ffffff')); ?>" class="cpwa-color-picker" data-preview="button-text">
                                <p class="description"><?php esc_html_e('Text color of the install button', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_popup_overlay_color"><?php esc_html_e('Overlay Color', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="cpwa_popup_overlay_color" name="cpwa_popup_overlay_color" value="<?php echo esc_attr(get_option('cpwa_popup_overlay_color', 'rgba(0,0,0,0.6)')); ?>" class="cpwa-color-picker" data-preview="overlay">
                                <p class="description"><?php esc_html_e('Background overlay color behind the popup', 'custom-pwa-installer'); ?></p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
            <div class="cpwa-settings-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
                <h2><?php esc_html_e('App Icons', 'custom-pwa-installer'); ?></h2>
                
                <table class="form-table" role="presentation">
                    <tbody>
                        <tr>
                            <th scope="row">
                                <label for="cpwa_icon_192"><?php esc_html_e('Icon 192x192', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="url" id="cpwa_icon_192" name="cpwa_icon_192" value="<?php echo esc_url(get_option('cpwa_icon_192', '')); ?>" class="regular-text cpwa-icon-url">
                                <button type="button" class="button cpwa-upload-icon" data-target="cpwa_icon_192"><?php esc_html_e('Upload Icon', 'custom-pwa-installer'); ?></button>
                                <p class="description"><?php esc_html_e('192x192 PNG icon (leave empty to use default)', 'custom-pwa-installer'); ?></p>
                                <?php if (get_option('cpwa_icon_192')) : ?>
                                    <div class="cpwa-icon-preview">
                                        <img src="<?php echo esc_url(get_option('cpwa_icon_192')); ?>" alt="Icon 192x192" style="max-width: 100px; height: auto; border: 1px solid #ddd; padding: 5px; margin-top: 10px;">
                                    </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label for="cpwa_icon_512"><?php esc_html_e('Icon 512x512', 'custom-pwa-installer'); ?></label>
                            </th>
                            <td>
                                <input type="url" id="cpwa_icon_512" name="cpwa_icon_512" value="<?php echo esc_url(get_option('cpwa_icon_512', '')); ?>" class="regular-text cpwa-icon-url">
                                <button type="button" class="button cpwa-upload-icon" data-target="cpwa_icon_512"><?php esc_html_e('Upload Icon', 'custom-pwa-installer'); ?></button>
                                <p class="description"><?php esc_html_e('512x512 PNG icon (leave empty to use default)', 'custom-pwa-installer'); ?></p>
                                <?php if (get_option('cpwa_icon_512')) : ?>
                                    <div class="cpwa-icon-preview">
                                        <img src="<?php echo esc_url(get_option('cpwa_icon_512')); ?>" alt="Icon 512x512" style="max-width: 100px; height: auto; border: 1px solid #ddd; padding: 5px; margin-top: 10px;">
                                    </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
            <div class="cpwa-settings-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
                <h2><?php esc_html_e('Customization Manual', 'custom-pwa-installer'); ?></h2>
                
                <div class="cpwa-manual-container" style="background: #f8f9fa; padding: 25px; border-radius: 8px; margin-top: 15px;">
                    <h3 style="margin-top: 0; color: #333; font-size: 18px;"><?php esc_html_e('How to Customize Your PWA Install Popup', 'custom-pwa-installer'); ?></h3>
                    
                    <div style="line-height: 1.8; color: #555;">
                        <h4 style="color: #2271b1; margin-top: 20px; margin-bottom: 10px;"><?php esc_html_e('1. Upload Your Logo/Icon', 'custom-pwa-installer'); ?></h4>
                        <p style="margin: 0 0 15px 0;">
                            <?php esc_html_e('Go to the "App Icons" section above and upload your custom icons. The popup will automatically display your logo instead of the default icon.', 'custom-pwa-installer'); ?>
                        </p>
                        <ul style="margin: 10px 0 15px 20px;">
                            <li><?php esc_html_e('Recommended: Upload both 192x192 and 512x512 PNG icons', 'custom-pwa-installer'); ?></li>
                            <li><?php esc_html_e('The popup will use your 192x192 icon automatically', 'custom-pwa-installer'); ?></li>
                            <li><?php esc_html_e('If only one icon is uploaded, it will be used for both sizes', 'custom-pwa-installer'); ?></li>
                        </ul>
                        
                        <h4 style="color: #2271b1; margin-top: 20px; margin-bottom: 10px;"><?php esc_html_e('2. Customize Colors', 'custom-pwa-installer'); ?></h4>
                        <p style="margin: 0 0 15px 0;">
                            <?php esc_html_e('Use the "Popup Appearance" section to customize:', 'custom-pwa-installer'); ?>
                        </p>
                        <ul style="margin: 10px 0 15px 20px;">
                            <li><strong><?php esc_html_e('Popup Background:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Main popup background color', 'custom-pwa-installer'); ?></li>
                            <li><strong><?php esc_html_e('Text Color:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Color for title and description text', 'custom-pwa-installer'); ?></li>
                            <li><strong><?php esc_html_e('Button Background:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Install button background color', 'custom-pwa-installer'); ?></li>
                            <li><strong><?php esc_html_e('Button Text Color:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Install button text color', 'custom-pwa-installer'); ?></li>
                            <li><strong><?php esc_html_e('Overlay Color:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Background overlay behind the popup', 'custom-pwa-installer'); ?></li>
                        </ul>
                        
                        <h4 style="color: #2271b1; margin-top: 20px; margin-bottom: 10px;"><?php esc_html_e('3. Customize Text', 'custom-pwa-installer'); ?></h4>
                        <p style="margin: 0 0 15px 0;">
                            <?php esc_html_e('In the "Install Button Settings" section, you can customize:', 'custom-pwa-installer'); ?>
                        </p>
                        <ul style="margin: 10px 0 15px 20px;">
                            <li><strong><?php esc_html_e('Install Button Text:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Text shown on the install button', 'custom-pwa-installer'); ?></li>
                            <li><strong><?php esc_html_e('Popup Description:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Description text in the popup modal', 'custom-pwa-installer'); ?></li>
                            <li><strong><?php esc_html_e('Installing Text:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Text shown during installation', 'custom-pwa-installer'); ?></li>
                        </ul>
                        
                        <h4 style="color: #2271b1; margin-top: 20px; margin-bottom: 10px;"><?php esc_html_e('4. Preview Your Changes', 'custom-pwa-installer'); ?></h4>
                        <p style="margin: 0 0 15px 0;">
                            <?php esc_html_e('Use the "Live Preview" section in "Popup Appearance" to see your changes in real-time. Click the "Show Popup Preview" button to see the full popup modal with your current settings via AJAX.', 'custom-pwa-installer'); ?>
                        </p>
                        
                        <h4 style="color: #2271b1; margin-top: 20px; margin-bottom: 10px;"><?php esc_html_e('5. Save Settings', 'custom-pwa-installer'); ?></h4>
                        <p style="margin: 0;">
                            <?php esc_html_e('After making your customizations, click "Save Settings" at the bottom of the page to apply all changes.', 'custom-pwa-installer'); ?>
                        </p>
                        
                        <div style="background: #e7f3ff; padding: 15px; border-left: 4px solid #2271b1; margin-top: 20px; border-radius: 4px;">
                            <p style="margin: 0; font-weight: 600; color: #2271b1;">
                                <?php esc_html_e('💡 Tip:', 'custom-pwa-installer'); ?>
                            </p>
                            <p style="margin: 5px 0 0 0;">
                                <?php esc_html_e('The popup automatically displays your uploaded logo/icon. If no custom icon is uploaded, it will show a default gradient icon. Make sure to upload square PNG images for best results.', 'custom-pwa-installer'); ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="cpwa-settings-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
                <h2><?php esc_html_e('PWA Status', 'custom-pwa-installer'); ?></h2>
                
                <table class="form-table" role="presentation">
                    <tbody>
                        <tr>
                            <th scope="row"><?php esc_html_e('HTTPS Status', 'custom-pwa-installer'); ?></th>
                            <td>
                                <?php if (is_ssl()) : ?>
                                    <span style="color: #46b450;">✓ <?php esc_html_e('Enabled', 'custom-pwa-installer'); ?></span>
                                <?php else : ?>
                                    <span style="color: #dc3232;">✗ <?php esc_html_e('Disabled (Required for PWA)', 'custom-pwa-installer'); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><?php esc_html_e('Manifest URL', 'custom-pwa-installer'); ?></th>
                            <td>
                                <a href="<?php echo esc_url(home_url('/pwa-manifest.json')); ?>" target="_blank"><?php echo esc_url(home_url('/pwa-manifest.json')); ?></a>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><?php esc_html_e('Service Worker URL', 'custom-pwa-installer'); ?></th>
                            <td>
                                <a href="<?php echo esc_url(home_url('/sw.js')); ?>" target="_blank"><?php echo esc_url(home_url('/sw.js')); ?></a>
                                <p class="description" style="margin-top: 5px;">
                                    <strong><?php esc_html_e('Important:', 'custom-pwa-installer'); ?></strong> 
                                    <?php esc_html_e('If this URL redirects or shows an error, check:', 'custom-pwa-installer'); ?>
                                    <br>• <?php esc_html_e('Flush rewrite rules (Settings → Permalinks → Save)', 'custom-pwa-installer'); ?>
                                    <br>• <?php esc_html_e('Disable caching plugins temporarily to test', 'custom-pwa-installer'); ?>
                                    <br>• <?php esc_html_e('Check security plugins for URL blocking', 'custom-pwa-installer'); ?>
                                    <br>• <?php esc_html_e('Verify .htaccess is writable and not blocking /sw.js', 'custom-pwa-installer'); ?>
                                </p>
                            </td>
                        </tr>
                    </tbody>
                </table>
                
                <p style="margin-top: 20px; padding: 15px; background: #e7f3ff; border-left: 4px solid #2271b1;">
                    <strong><?php esc_html_e('Testing Your PWA:', 'custom-pwa-installer'); ?></strong><br>
                    <?php esc_html_e('1. Open Chrome DevTools (F12)', 'custom-pwa-installer'); ?><br>
                    <?php esc_html_e('2. Go to "Application" tab', 'custom-pwa-installer'); ?><br>
                    <?php esc_html_e('3. Check "Manifest" and "Service Workers" sections', 'custom-pwa-installer'); ?><br>
                    <?php esc_html_e('4. Use "Lighthouse" tab to run a PWA audit', 'custom-pwa-installer'); ?>
                </p>
            </div>
            
            <?php submit_button(__('Save Settings', 'custom-pwa-installer'), 'primary', 'cpwa_save_settings'); ?>
        </form>
    </div>
</div>

<style>
.cpwa-color-picker {
    max-width: 100px;
}

/* Popup Preview Overlay Styles */
#cpwa-popup-preview-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    z-index: 999999;
    background: rgba(0, 0, 0, 0.7);
    backdrop-filter: blur(5px);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
}

#cpwa-popup-preview-content {
    position: relative;
    max-width: 90%;
    max-height: 90%;
    overflow: auto;
    width: 100%;
}

#cpwa-popup-preview-content .cpwa-install-popup {
    position: relative;
    max-width: 420px;
    margin: 0 auto;
}

#cpwa-popup-preview-content .cpwa-popup-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    border-radius: 20px;
}

#cpwa-popup-preview-content .cpwa-popup-content {
    position: relative;
    z-index: 1;
}

.cpwa-preview-close:hover {
    background: #e0e0e0;
    color: #333333;
    transform: rotate(90deg);
}

</style>

<script>
jQuery(document).ready(function($) {
    // Color picker
    if (typeof $.fn.wpColorPicker !== 'undefined') {
        $('.cpwa-color-picker').wpColorPicker({
            change: function(event, ui) {
                updateLivePreview();
            },
            clear: function() {
                updateLivePreview();
            }
        });
    }
    
    // Initialize live preview
    initLivePreview();
    
    // Update preview when any setting changes
    $('input, textarea').on('input change', function() {
        if ($(this).hasClass('cpwa-color-picker') || 
            $(this).attr('id') === 'cpwa_install_button_text' ||
            $(this).attr('id') === 'cpwa_popup_description' ||
            $(this).hasClass('cpwa-icon-url')) {
            updateLivePreview();
            updatePopupPreviewIcon();
        }
    });
    
    /**
     * Initialize live preview
     */
    function initLivePreview() {
        const container = $('#cpwa-preview-container');
        if (container.length === 0) return;
        
        // Create preview HTML
        const previewHtml = `
            <div class="cpwa-preview-popup" style="position: relative; background: #ffffff; border-radius: 12px; padding: 20px; box-shadow: 0 4px 20px rgba(0,0,0,0.15); max-width: 100%;">
                <div class="cpwa-preview-overlay" style="position: absolute; top: -10px; left: -10px; right: -10px; bottom: -10px; background: rgba(0,0,0,0.6); border-radius: 16px; z-index: -1;"></div>
                <div class="cpwa-preview-close" style="position: absolute; top: 10px; right: 10px; width: 24px; height: 24px; background: #f5f5f5; border-radius: 50%; display: flex; align-items: center; justify-content: center; cursor: pointer; font-size: 16px; color: #666;">×</div>
                <div class="cpwa-preview-body" style="text-align: center;">
                    <div class="cpwa-preview-icon" style="width: 60px; height: 60px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 12px; margin: 0 auto 15px; display: flex; align-items: center; justify-content: center; overflow: hidden;">
                        <?php 
                        $preview_icon = get_option('cpwa_icon_192') ?: get_option('cpwa_icon_512', '');
                        if ($preview_icon) : ?>
                            <img src="<?php echo esc_url($preview_icon); ?>" style="width: 100%; height: 100%; object-fit: contain; border-radius: 12px;" alt="App Icon">
                        <?php else : ?>
                            <svg width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2">
                                <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                                <polyline points="7 10 12 15 17 10"></polyline>
                                <line x1="12" y1="15" x2="12" y2="3"></line>
                            </svg>
                        <?php endif; ?>
                    </div>
                    <h3 class="cpwa-preview-title" style="margin: 0 0 10px; font-size: 18px; font-weight: 700; color: #333;">Install App</h3>
                    <p class="cpwa-preview-description" style="margin: 0 0 20px; font-size: 14px; color: #666; line-height: 1.5;">Install our app for a better experience.</p>
                    <button class="cpwa-preview-button" style="padding: 12px 24px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none; border-radius: 25px; font-size: 14px; font-weight: 600; cursor: pointer; display: flex; align-items: center; gap: 8px; margin: 0 auto;">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                            <polyline points="7 10 12 15 17 10"></polyline>
                            <line x1="12" y1="15" x2="12" y2="3"></line>
                        </svg>
                        <span>Install App</span>
                    </button>
                </div>
            </div>
        `;
        
        container.html(previewHtml);
        updateLivePreview();
    }
    
    /**
     * Update live preview with current settings
     */
    function updateLivePreview() {
        const popup = $('.cpwa-preview-popup');
        if (popup.length === 0) return;
        
        // Get current values
        const bgColor = $('#cpwa_popup_background_color').val() || '#ffffff';
        const textColor = $('#cpwa_popup_text_color').val() || '#333333';
        const buttonColor = $('#cpwa_popup_button_color').val() || '#667eea';
        const buttonTextColor = $('#cpwa_popup_button_text_color').val() || '#ffffff';
        const overlayColor = $('#cpwa_popup_overlay_color').val() || 'rgba(0,0,0,0.6)';
        const buttonText = $('#cpwa_install_button_text').val() || 'Install App';
        const description = $('#cpwa_popup_description').val() || 'Install our app for a better experience.';
        
        // Get icon URL
        const icon192 = $('#cpwa_icon_192').val();
        const icon512 = $('#cpwa_icon_512').val();
        const iconUrl = icon192 || icon512;
        
        // Update preview styles
        popup.css('background', bgColor);
        popup.find('.cpwa-preview-title').css('color', textColor);
        popup.find('.cpwa-preview-description').css('color', textColor).css('opacity', '0.8');
        popup.find('.cpwa-preview-button').css('background', buttonColor).css('color', buttonTextColor);
        popup.find('.cpwa-preview-button span').text(buttonText);
        popup.find('.cpwa-preview-description').text(description.length > 60 ? description.substring(0, 60) + '...' : description);
        popup.find('.cpwa-preview-overlay').css('background', overlayColor);
        
        // Update icon
        const previewIcon = popup.find('.cpwa-preview-icon');
        if (iconUrl) {
            previewIcon.css('background', 'transparent');
            if (previewIcon.find('img').length) {
                previewIcon.find('img').attr('src', iconUrl);
            } else {
                previewIcon.html('<img src="' + iconUrl + '" style="width: 100%; height: 100%; object-fit: contain; border-radius: 12px;">');
            }
        } else {
            previewIcon.css('background', 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)');
            if (!previewIcon.find('svg').length) {
                previewIcon.html('<svg width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="7 10 12 15 17 10"></polyline><line x1="12" y1="15" x2="12" y2="3"></line></svg>');
            }
        }
        
        // Add hover effect for button
        popup.find('.cpwa-preview-button').hover(
            function() {
                $(this).css('transform', 'translateY(-2px)');
                $(this).css('box-shadow', '0 6px 20px ' + buttonColor + '40');
            },
            function() {
                $(this).css('transform', 'translateY(0)');
                $(this).css('box-shadow', 'none');
            }
        );
    }
    
    // Media uploader for icons - Fixed version
    var iconUploaders = {}; // Store separate uploader for each icon size
    
    $('.cpwa-upload-icon').on('click', function(e) {
        e.preventDefault();
        
        // Check if wp.media is available
        if (typeof wp === 'undefined' || typeof wp.media === 'undefined') {
            alert('<?php esc_html_e('WordPress Media Library is not available. Please refresh the page and try again.', 'custom-pwa-installer'); ?>');
            return false;
        }
        
        var button = $(this);
        var targetId = button.data('target');
        var targetInput = $('#' + targetId);
        var targetSize = targetId === 'cpwa_icon_192' ? '192x192' : '512x512';
        
        if (!targetInput.length) {
            alert('<?php esc_html_e('Error: Target input field not found.', 'custom-pwa-installer'); ?>');
            return false;
        }
        
        // Create or reuse media uploader instance for this specific icon
        if (!iconUploaders[targetId]) {
            iconUploaders[targetId] = wp.media({
                title: '<?php esc_html_e('Choose PWA Icon', 'custom-pwa-installer'); ?> (' + targetSize + ')',
                button: {
                    text: '<?php esc_html_e('Use This Icon', 'custom-pwa-installer'); ?>'
                },
                library: {
                    type: 'image'
                },
                multiple: false
            });
            
            // Handle selection
            iconUploaders[targetId].on('select', function() {
                var attachment = iconUploaders[targetId].state().get('selection').first().toJSON();
                
                if (!attachment || !attachment.url) {
                    alert('<?php esc_html_e('Error: Could not get image URL.', 'custom-pwa-installer'); ?>');
                    return;
                }
                
                // Validate image dimensions if available
                if (attachment.width && attachment.height) {
                    var expectedSize = targetSize.split('x');
                    var expectedWidth = parseInt(expectedSize[0]);
                    var expectedHeight = parseInt(expectedSize[1]);
                    
                    if (attachment.width !== expectedWidth || attachment.height !== expectedHeight) {
                        var confirmMsg = '<?php esc_html_e('Warning: Selected image is', 'custom-pwa-installer'); ?> ' + 
                                        attachment.width + 'x' + attachment.height + 
                                        '. <?php esc_html_e('Recommended size is', 'custom-pwa-installer'); ?> ' + targetSize + 
                                        '. <?php esc_html_e('Continue anyway?', 'custom-pwa-installer'); ?>';
                        if (!confirm(confirmMsg)) {
                            return;
                        }
                    }
                }
                
                // Set the input value
                targetInput.val(attachment.url);
                
                // Show or update preview
                var preview = targetInput.closest('td').find('.cpwa-icon-preview');
                if (preview.length) {
                    preview.find('img').attr('src', attachment.url).attr('alt', 'Icon Preview');
                } else {
                    var previewHtml = '<div class="cpwa-icon-preview" style="margin-top: 10px;">' +
                        '<img src="' + attachment.url + '" alt="Icon Preview" style="max-width: 100px; height: auto; border: 1px solid #ddd; padding: 5px; display: block; border-radius: 4px;">' +
                        '</div>';
                    targetInput.closest('td').find('.cpwa-icon-url').after(previewHtml);
                }
                
                // Update popup preview if it exists
                updatePopupPreviewIcon();
            });
            
            // Handle errors
            iconUploaders[targetId].on('error', function(error) {
                alert('<?php esc_html_e('Error opening media library. Please try again.', 'custom-pwa-installer'); ?>');
            });
        }
        
        // Open media uploader
        iconUploaders[targetId].open();
        return false;
    });
    
    // Function to update popup preview icon
    function updatePopupPreviewIcon() {
        var icon192 = $('#cpwa_icon_192').val();
        var icon512 = $('#cpwa_icon_512').val();
        var iconToUse = icon192 || icon512;
        
        var previewIcon = $('.cpwa-preview-icon');
        if (previewIcon.length) {
            if (iconToUse) {
                previewIcon.css('background', 'transparent');
                if (previewIcon.find('img').length) {
                    previewIcon.find('img').attr('src', iconToUse);
                } else {
                    previewIcon.html('<img src="' + iconToUse + '" style="width: 100%; height: 100%; object-fit: contain; border-radius: 12px;">');
                }
            } else {
                // Reset to default gradient icon
                previewIcon.css('background', 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)');
                if (!previewIcon.find('svg').length) {
                    previewIcon.html('<svg width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="7 10 12 15 17 10"></polyline><line x1="12" y1="15" x2="12" y2="3"></line></svg>');
                }
            }
        }
    }
    
    // Update preview icon when icon URLs are manually changed
    $('.cpwa-icon-url').on('input change blur', function() {
        updatePopupPreviewIcon();
        updateLivePreview();
    });
    
    // AJAX Popup Preview Handler
    $('#cpwa-show-popup-preview').on('click', function(e) {
        e.preventDefault();
        
        var button = $(this);
        var originalText = button.text();
        button.prop('disabled', true).text('<?php esc_html_e('Loading...', 'custom-pwa-installer'); ?>');
        
        // Get current settings
        var settings = {
            action: 'cpwa_get_popup_preview',
            nonce: '<?php echo wp_create_nonce('cpwa_admin_nonce'); ?>',
            popup_bg: $('#cpwa_popup_background_color').val() || '#ffffff',
            popup_text: $('#cpwa_popup_text_color').val() || '#333333',
            popup_button: $('#cpwa_popup_button_color').val() || '#667eea',
            popup_button_text: $('#cpwa_popup_button_text_color').val() || '#ffffff',
            popup_overlay: $('#cpwa_popup_overlay_color').val() || 'rgba(0,0,0,0.6)',
            button_text: $('#cpwa_install_button_text').val() || 'Install App',
            description: $('#cpwa_popup_description').val() || 'Install our app for a better experience.',
            icon_192: $('#cpwa_icon_192').val() || '',
            icon_512: $('#cpwa_icon_512').val() || ''
        };
        
        // Make AJAX request
        var ajaxUrl = typeof ajaxurl !== 'undefined' ? ajaxurl : '<?php echo admin_url('admin-ajax.php'); ?>';
        
        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: settings,
            success: function(response) {
                if (response.success && response.data && response.data.html) {
                    // Show the popup preview overlay
                    var overlay = $('#cpwa-popup-preview-overlay');
                    var content = $('#cpwa-popup-preview-content');
                    
                    // Insert the popup HTML
                    content.html(response.data.html);
                    
                    // Show overlay with animation
                    overlay.css('display', 'flex').hide().fadeIn(300);
                    
                    // Make overlay scrollable
                    $('body').css('overflow', 'hidden');
                } else {
                    alert('<?php esc_html_e('Error loading popup preview. Please try again.', 'custom-pwa-installer'); ?>');
                }
                
                button.prop('disabled', false).text(originalText);
            },
            error: function(xhr, status, error) {
                alert('<?php esc_html_e('Error loading popup preview: ', 'custom-pwa-installer'); ?>' + error);
                button.prop('disabled', false).text(originalText);
            }
        });
    });
    
    // Close popup preview when clicking close button or overlay
    $(document).on('click', '.cpwa-preview-close, #cpwa-popup-preview-overlay', function(e) {
        // Don't close if clicking inside the popup content
        if ($(e.target).closest('.cpwa-popup-content').length) {
            return;
        }
        
        $('#cpwa-popup-preview-overlay').fadeOut(300, function() {
            $(this).css('display', 'none');
            $('body').css('overflow', '');
        });
    });
    
    // Prevent closing when clicking inside popup content
    $(document).on('click', '.cpwa-popup-content', function(e) {
        e.stopPropagation();
    });
});
</script>

