# PWA Icons

## Required Icon Sizes

For your PWA to be installable, you need to provide icons in the following sizes:

- **192x192 pixels** - Required, used on Android home screen
- **512x512 pixels** - Required, used for splash screen

## Icon Requirements

1. **Format**: PNG (preferred) or JPEG
2. **Shape**: Square (same width and height)
3. **Background**: Can be transparent or solid color
4. **Purpose**: Set to "any maskable" for best compatibility

## Creating Icons

### Quick Icon Generators

1. **Favicon.io** (https://favicon.io/)
   - Create from text, image, or emoji
   - Free and easy to use
   - Downloads all sizes

2. **RealFaviconGenerator** (https://realfavicongenerator.net/)
   - Upload your logo
   - Generates all PWA icons
   - Shows previews on different devices

3. **PWA Asset Generator** (CLI tool)
   ```bash
   npx pwa-asset-generator [source] [output-folder]
   ```

### Manual Creation with Photoshop/GIMP

1. Create a new file: 512x512 pixels
2. Design your icon (keep important content in center 80%)
3. Export as PNG with transparency
4. Resize to 192x192 for the smaller version

### Using Canva

1. Create custom size: 512x512
2. Design your icon
3. Download as PNG
4. Use image resizer for 192x192 version

## Default Icons

This plugin includes default placeholder icons. **You should replace these with your own branded icons.**

To replace:

1. Go to **WordPress Admin → Settings → PWA Settings**
2. Scroll to "App Icons" section
3. Click "Upload Icon" buttons
4. Select your 192x192 and 512x512 PNG files
5. Click "Save Settings"

## Icon Best Practices

### Design Guidelines

1. **Simple is Better**: Icons should be recognizable at small sizes
2. **High Contrast**: Ensure visibility on all backgrounds
3. **Centered Content**: Keep key elements in the center 80%
4. **No Text**: Avoid small text (won't be readable)
5. **Brand Consistency**: Match your brand colors

### Safe Zone

When designing, keep important content within the center 80% of the canvas. This ensures compatibility with:

- Android's circular masks
- iOS rounded corners
- Different device shapes

### Testing Your Icons

1. Upload icons to your PWA settings
2. Visit `/pwa-manifest.json` in your browser
3. Check that icon URLs are correct
4. Install PWA on test device
5. Check home screen appearance

## Troubleshooting

### Icons Not Showing

**Problem**: Icons don't appear after installation

**Solutions**:
- Verify icon URLs in manifest (visit manifest.json)
- Check that icon files are accessible (visit URLs directly)
- Clear browser cache
- Reinstall the PWA
- Verify icons are exactly 192x192 and 512x512 pixels

### Icons Look Stretched

**Problem**: Icons appear distorted

**Solutions**:
- Ensure icons are perfectly square
- Use PNG format
- Don't use non-square images

### Icons Have Wrong Background

**Problem**: Icons have unexpected background color

**Solutions**:
- Save as PNG with transparency
- Or use solid background color matching your theme
- Check `background_color` setting in PWA Settings

## Example Icon Sizes Table

| Device | Icon Used | Display Size |
|--------|-----------|--------------|
| Android Home Screen | 192x192 | 48dp - 72dp |
| Android Splash Screen | 512x512 | Centered, scaled |
| iOS Home Screen | 512x512 | 180x180 (scaled) |
| Desktop Taskbar | 192x192 | 32px - 48px (scaled) |

## Quick Start

1. Go to https://favicon.io/
2. Choose "Text" or "Image"
3. Generate icons
4. Download the package
5. Upload android-chrome-192x192.png and android-chrome-512x512.png
6. Done!

---

**Need more help?** Check the main README.md file or WordPress admin settings page.

