<?php
/**
 * Admin Help Page Template
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="cpwa-help-container" style="max-width: 900px;">
        
        <!-- Quick Start Guide -->
        <div class="cpwa-help-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
            <h2><?php esc_html_e('🚀 Quick Start Guide', 'custom-pwa-installer'); ?></h2>
            
            <div style="line-height: 1.8;">
                <h3><?php esc_html_e('Step 1: Configure Settings', 'custom-pwa-installer'); ?></h3>
                <p><?php esc_html_e('Go to PWA Installer → Settings and fill in:', 'custom-pwa-installer'); ?></p>
                <ul style="margin-left: 20px;">
                    <li><?php esc_html_e('App Name (e.g., "My Awesome App")', 'custom-pwa-installer'); ?></li>
                    <li><?php esc_html_e('Short Name (max 12 chars)', 'custom-pwa-installer'); ?></li>
                    <li><?php esc_html_e('Theme Color (your brand color)', 'custom-pwa-installer'); ?></li>
                </ul>
                
                <h3 style="margin-top: 20px;"><?php esc_html_e('Step 2: Upload Icons', 'custom-pwa-installer'); ?></h3>
                <p><?php esc_html_e('Upload two PNG icons:', 'custom-pwa-installer'); ?></p>
                <ul style="margin-left: 20px;">
                    <li><?php esc_html_e('192x192 pixels (required)', 'custom-pwa-installer'); ?></li>
                    <li><?php esc_html_e('512x512 pixels (required)', 'custom-pwa-installer'); ?></li>
                </ul>
                <p><strong><?php esc_html_e('Quick Icon Creation:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Visit', 'custom-pwa-installer'); ?> <a href="https://favicon.io/" target="_blank">favicon.io</a> <?php esc_html_e('to generate icons from text or image', 'custom-pwa-installer'); ?></p>
                
                <h3 style="margin-top: 20px;"><?php esc_html_e('Step 3: Flush Permalinks', 'custom-pwa-installer'); ?></h3>
                <p>
                    <?php esc_html_e('Go to Settings → Permalinks and click "Save Changes"', 'custom-pwa-installer'); ?>
                    <br>
                    <a href="<?php echo esc_url(admin_url('options-permalink.php')); ?>" class="button button-small" style="margin-top: 10px;"><?php esc_html_e('Go to Permalinks', 'custom-pwa-installer'); ?></a>
                </p>
                
                <h3 style="margin-top: 20px;"><?php esc_html_e('Step 4: Test Installation', 'custom-pwa-installer'); ?></h3>
                <p>
                    <?php esc_html_e('Visit your website and look for the "Install App" button (bottom center)', 'custom-pwa-installer'); ?>
                    <br>
                    <a href="<?php echo esc_url(home_url('/')); ?>" target="_blank" class="button button-primary button-small" style="margin-top: 10px;"><?php esc_html_e('Open Homepage', 'custom-pwa-installer'); ?></a>
                </p>
            </div>
        </div>
        
        <!-- Troubleshooting -->
        <div class="cpwa-help-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
            <h2><?php esc_html_e('🔧 Troubleshooting', 'custom-pwa-installer'); ?></h2>
            
            <div class="cpwa-accordion">
                <h3><?php esc_html_e('Install button not showing?', 'custom-pwa-installer'); ?></h3>
                <div style="margin-left: 20px; margin-bottom: 20px;">
                    <p><strong><?php esc_html_e('Possible causes:', 'custom-pwa-installer'); ?></strong></p>
                    <ul>
                        <li>✗ <?php esc_html_e('Site not using HTTPS (required)', 'custom-pwa-installer'); ?></li>
                        <li>✗ <?php esc_html_e('Icons not uploaded', 'custom-pwa-installer'); ?></li>
                        <li>✗ <?php esc_html_e('PWA already installed', 'custom-pwa-installer'); ?></li>
                        <li>✗ <?php esc_html_e('Browser cache needs clearing', 'custom-pwa-installer'); ?></li>
                    </ul>
                    <p><strong><?php esc_html_e('Solutions:', 'custom-pwa-installer'); ?></strong></p>
                    <ol>
                        <li><?php esc_html_e('Enable HTTPS on your site', 'custom-pwa-installer'); ?></li>
                        <li><?php esc_html_e('Upload 192x192 and 512x512 icons', 'custom-pwa-installer'); ?></li>
                        <li><?php esc_html_e('Test in incognito/private mode', 'custom-pwa-installer'); ?></li>
                        <li><?php esc_html_e('Clear browser cache and reload', 'custom-pwa-installer'); ?></li>
                    </ol>
                </div>
                
                <h3><?php esc_html_e('Manifest not loading?', 'custom-pwa-installer'); ?></h3>
                <div style="margin-left: 20px; margin-bottom: 20px;">
                    <p><strong><?php esc_html_e('Quick fix:', 'custom-pwa-installer'); ?></strong></p>
                    <ol>
                        <li><?php esc_html_e('Go to Settings → Permalinks', 'custom-pwa-installer'); ?></li>
                        <li><?php esc_html_e('Click "Save Changes" (this flushes rewrite rules)', 'custom-pwa-installer'); ?></li>
                        <li><?php esc_html_e('Visit', 'custom-pwa-installer'); ?> <a href="<?php echo esc_url(home_url('/pwa-manifest.json')); ?>" target="_blank">/pwa-manifest.json</a> <?php esc_html_e('to verify', 'custom-pwa-installer'); ?></li>
                    </ol>
                </div>
                
                <h3><?php esc_html_e('Service worker not registering?', 'custom-pwa-installer'); ?></h3>
                <div style="margin-left: 20px; margin-bottom: 20px;">
                    <p><strong><?php esc_html_e('Check these:', 'custom-pwa-installer'); ?></strong></p>
                    <ul>
                        <li><?php esc_html_e('Visit', 'custom-pwa-installer'); ?> <a href="<?php echo esc_url(home_url('/sw.js')); ?>" target="_blank">/sw.js</a> <?php esc_html_e('- should show JavaScript code', 'custom-pwa-installer'); ?></li>
                        <li><?php esc_html_e('Open browser console (F12) and look for errors', 'custom-pwa-installer'); ?></li>
                        <li><?php esc_html_e('Make sure HTTPS is enabled (or using localhost)', 'custom-pwa-installer'); ?></li>
                        <li><?php esc_html_e('Disable other PWA or caching plugins', 'custom-pwa-installer'); ?></li>
                    </ul>
                </div>
                
                <h3><?php esc_html_e('Icons not showing after install?', 'custom-pwa-installer'); ?></h3>
                <div style="margin-left: 20px; margin-bottom: 20px;">
                    <p><strong><?php esc_html_e('Verify:', 'custom-pwa-installer'); ?></strong></p>
                    <ol>
                        <li><?php esc_html_e('Icons are uploaded in Settings', 'custom-pwa-installer'); ?></li>
                        <li><?php esc_html_e('Icons are exactly 192x192 and 512x512 pixels', 'custom-pwa-installer'); ?></li>
                        <li><?php esc_html_e('Icons are PNG format', 'custom-pwa-installer'); ?></li>
                        <li><?php esc_html_e('Check manifest for correct icon URLs', 'custom-pwa-installer'); ?></li>
                    </ol>
                </div>
            </div>
        </div>
        
        <!-- Browser Support -->
        <div class="cpwa-help-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
            <h2><?php esc_html_e('📱 Browser Support', 'custom-pwa-installer'); ?></h2>
            
            <table class="widefat" style="margin-top: 10px;">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Browser', 'custom-pwa-installer'); ?></th>
                        <th><?php esc_html_e('Support', 'custom-pwa-installer'); ?></th>
                        <th><?php esc_html_e('Notes', 'custom-pwa-installer'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><strong>Chrome (Android)</strong></td>
                        <td><span style="color: #46b450;">✓ Full</span></td>
                        <td><?php esc_html_e('Perfect PWA support with custom install button', 'custom-pwa-installer'); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Chrome (Desktop)</strong></td>
                        <td><span style="color: #46b450;">✓ Full</span></td>
                        <td><?php esc_html_e('Perfect PWA support with custom install button', 'custom-pwa-installer'); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Edge (Desktop)</strong></td>
                        <td><span style="color: #46b450;">✓ Full</span></td>
                        <td><?php esc_html_e('Chromium-based, same as Chrome', 'custom-pwa-installer'); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Safari (iOS)</strong></td>
                        <td><span style="color: #f0ad4e;">⚠ Partial</span></td>
                        <td><?php esc_html_e('Shows manual install instructions (no beforeinstallprompt)', 'custom-pwa-installer'); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Safari (macOS)</strong></td>
                        <td><span style="color: #f0ad4e;">⚠ Limited</span></td>
                        <td><?php esc_html_e('Limited PWA support', 'custom-pwa-installer'); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Firefox</strong></td>
                        <td><span style="color: #dc3232;">✗ Limited</span></td>
                        <td><?php esc_html_e('No beforeinstallprompt support', 'custom-pwa-installer'); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <!-- FAQs -->
        <div class="cpwa-help-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
            <h2><?php esc_html_e('❓ Frequently Asked Questions', 'custom-pwa-installer'); ?></h2>
            
            <h3><?php esc_html_e('Q: Do I need HTTPS?', 'custom-pwa-installer'); ?></h3>
            <p><strong><?php esc_html_e('A:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Yes, HTTPS is required for PWA features to work (except on localhost for testing).', 'custom-pwa-installer'); ?></p>
            
            <h3 style="margin-top: 20px;"><?php esc_html_e('Q: Will the browser install prompt appear automatically?', 'custom-pwa-installer'); ?></h3>
            <p><strong><?php esc_html_e('A:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('No! This plugin prevents the auto-prompt. Only your custom "Install App" button will appear.', 'custom-pwa-installer'); ?></p>
            
            <h3 style="margin-top: 20px;"><?php esc_html_e('Q: What happens on iOS Safari?', 'custom-pwa-installer'); ?></h3>
            <p><strong><?php esc_html_e('A:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('iOS Safari doesn\'t support the beforeinstallprompt API, so the plugin shows a modal with step-by-step manual installation instructions.', 'custom-pwa-installer'); ?></p>
            
            <h3 style="margin-top: 20px;"><?php esc_html_e('Q: Can users use my site offline?', 'custom-pwa-installer'); ?></h3>
            <p><strong><?php esc_html_e('A:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Yes! The service worker caches pages and assets, so previously visited pages work offline. A custom offline page is shown for uncached pages.', 'custom-pwa-installer'); ?></p>
            
            <h3 style="margin-top: 20px;"><?php esc_html_e('Q: How do I customize the install button?', 'custom-pwa-installer'); ?></h3>
            <p><strong><?php esc_html_e('A:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Go to PWA Installer → Settings and customize button text, colors, and messages.', 'custom-pwa-installer'); ?></p>
            
            <h3 style="margin-top: 20px;"><?php esc_html_e('Q: Where can I see if my PWA is working?', 'custom-pwa-installer'); ?></h3>
            <p><strong><?php esc_html_e('A:', 'custom-pwa-installer'); ?></strong> <?php esc_html_e('Open Chrome DevTools (F12) → Application tab → Check Manifest and Service Workers sections.', 'custom-pwa-installer'); ?></p>
        </div>
        
        <!-- Resources -->
        <div class="cpwa-help-section" style="background: #e7f3ff; padding: 20px; margin-top: 20px; border-left: 4px solid #2271b1;">
            <h2><?php esc_html_e('📚 Helpful Resources', 'custom-pwa-installer'); ?></h2>
            
            <ul style="line-height: 1.8;">
                <li><strong><?php esc_html_e('Icon Generator:', 'custom-pwa-installer'); ?></strong> <a href="https://favicon.io/" target="_blank">favicon.io</a> - <?php esc_html_e('Create PWA icons easily', 'custom-pwa-installer'); ?></li>
                <li><strong><?php esc_html_e('Icon Generator:', 'custom-pwa-installer'); ?></strong> <a href="https://realfavicongenerator.net/" target="_blank">RealFaviconGenerator</a> - <?php esc_html_e('Comprehensive icon generator', 'custom-pwa-installer'); ?></li>
                <li><strong><?php esc_html_e('PWA Testing:', 'custom-pwa-installer'); ?></strong> <a href="https://developers.google.com/web/tools/lighthouse" target="_blank">Lighthouse</a> - <?php esc_html_e('Test your PWA score', 'custom-pwa-installer'); ?></li>
                <li><strong><?php esc_html_e('Learn More:', 'custom-pwa-installer'); ?></strong> <a href="https://web.dev/progressive-web-apps/" target="_blank">web.dev/pwa</a> - <?php esc_html_e('PWA documentation', 'custom-pwa-installer'); ?></li>
            </ul>
        </div>
        
        <!-- Contact -->
        <div class="cpwa-help-section" style="background: #fff; padding: 20px; margin-top: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
            <h2><?php esc_html_e('💬 Still Need Help?', 'custom-pwa-installer'); ?></h2>
            
            <p><?php esc_html_e('If you\'re still experiencing issues:', 'custom-pwa-installer'); ?></p>
            <ol style="line-height: 1.8;">
                <li><?php esc_html_e('Check the browser console (F12) for error messages', 'custom-pwa-installer'); ?></li>
                <li><?php esc_html_e('Test in incognito/private mode to rule out cache issues', 'custom-pwa-installer'); ?></li>
                <li><?php esc_html_e('Temporarily disable other plugins to check for conflicts', 'custom-pwa-installer'); ?></li>
                <li><?php esc_html_e('Verify HTTPS is properly configured', 'custom-pwa-installer'); ?></li>
            </ol>
            
            <p style="margin-top: 15px;">
                <a href="<?php echo esc_url(admin_url('admin.php?page=cpwa-tools')); ?>" class="button button-primary">
                    <?php esc_html_e('Go to Tools Page', 'custom-pwa-installer'); ?>
                </a>
            </p>
        </div>
        
    </div>
</div>

<style>
.cpwa-help-section h3 {
    margin-top: 20px;
    margin-bottom: 10px;
}
.cpwa-help-section ul,
.cpwa-help-section ol {
    margin-bottom: 15px;
}
</style>





