<?php
/**
 * Settings Functions
 *
 * @package ChristmasPopUpPro
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Get default settings
 */
function cpp_get_defaults() {
	return [
		'headline'          => '🎄 Merry Christmas',
		'subheadline'       => 'Christmas-Only Offer',
		'main_line'         => 'Buy any plan today — 50% OFF for Christmas only',
		'support_line'      => 'Limited-time holiday access to Ask Jenna',
		'primary_cta'       => 'Buy Now & Save 50%',
		'secondary_cta'     => 'No thanks',
		'bg_grad_start'     => '#f4e2d8',
		'bg_grad_end'       => '#e8c4b8',
		'text_color'        => '#ffffff',
		'btn_color'         => '#d32f2f',
		'btn_hover'         => '#b71c1c',
		'btn_hover_text'    => '#ffffff',
		'btn_secondary_hover_bg' => '',
		'accent_enable'     => 0,
		'accent_size'       => 80,
		'accent_opacity'    => 0.2,
		'accent_blur'       => 10,
		'accent_position'   => 'top-right',
		'primary_url'       => '/pricing?utm_source=christmas_popup',
		'delay_seconds'     => 5,
		'exit_intent'       => 1,
		'mobile_disable'    => 0,
		'cookie_days'       => 3,
		'hide_mins'         => 0,
		'hide_hours'        => 72,
		'hide_days'          => 0,
		'popup_image'        => '',
		'overlay_color'      => '#f4e2d8',
		'overlay_opacity'    => 0.7,
		'border_color'       => '',
		'border_width'       => 0,
		'border_style'       => 'solid',
		'border_radius'      => 12,
		'shadow_color'       => 'rgba(0, 0, 0, 0.3)',
		'shadow_blur'        => 40,
		'shadow_spread'      => 0,
		'shadow_x'           => 0,
		'shadow_y'           => 10,
		'disable_date'      => date( 'Y-12-31 23:59', current_time( 'timestamp' ) ),
	];
}

/**
 * Get plugin settings
 */
function cpp_get_settings() {
	$defaults = cpp_get_defaults();
	$settings = get_option( 'cpp_settings', [] );
	return wp_parse_args( $settings, $defaults );
}

/**
 * Activation hook
 */
function cpp_activate() {
	$defaults = cpp_get_defaults();
	$existing = get_option( 'cpp_settings', [] );
	
	// Only set defaults if no settings exist
	if ( empty( $existing ) ) {
		update_option( 'cpp_settings', $defaults );
	}
}

