<?php
/**
 * Asset Enqueuing Functions
 *
 * @package ChristmasPopUpPro
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Enqueue front-end assets
 */
function cpp_enqueue_assets() {
	$settings = cpp_get_settings();
	
	// Check if pop-up should be active
	$disable_date = isset( $settings['disable_date'] ) ? $settings['disable_date'] : '';
	if ( ! empty( $disable_date ) ) {
		$disable_timestamp = strtotime( $disable_date );
		$current_timestamp = current_time( 'timestamp' );
		
		// If expired, don't enqueue
		if ( $current_timestamp > $disable_timestamp ) {
			return;
		}
	}
	
	// Enqueue CSS
	wp_enqueue_style( 'cpp-public', CPP_PLUGIN_URL . 'assets/cpp-public.css', [], CPP_VERSION );
	
	// Generate dynamic CSS
	$dynamic_css = cpp_generate_dynamic_css( $settings );
	wp_add_inline_style( 'cpp-public', $dynamic_css );
	
	// Enqueue JS
	wp_enqueue_script( 'cpp-public', CPP_PLUGIN_URL . 'assets/cpp-public.js', [], CPP_VERSION, true );
	
	// Localize script with settings
	wp_localize_script( 'cpp-public', 'cppSettings', [
		'headline'       => esc_html( $settings['headline'] ),
		'subheadline'    => esc_html( $settings['subheadline'] ),
		'mainLine'       => esc_html( $settings['main_line'] ),
		'supportLine'    => esc_html( $settings['support_line'] ),
		'primaryCta'     => esc_html( $settings['primary_cta'] ),
		'secondaryCta'   => esc_html( $settings['secondary_cta'] ),
		'primaryUrl'     => esc_url( $settings['primary_url'] ),
		'accentEnable'    => absint( $settings['accent_enable'] ),
		'accentSize'      => absint( $settings['accent_size'] ),
		'accentOpacity'   => floatval( $settings['accent_opacity'] ),
		'accentBlur'     => absint( $settings['accent_blur'] ),
		'accentPosition'   => esc_attr( $settings['accent_position'] ),
		'delaySeconds'   => absint( $settings['delay_seconds'] ),
		'exitIntent'     => absint( $settings['exit_intent'] ),
		'mobileDisable'  => absint( $settings['mobile_disable'] ),
		'cookieDays'     => absint( $settings['cookie_days'] ),
		'hideMins'        => absint( $settings['hide_mins'] ),
		'hideHours'       => absint( $settings['hide_hours'] ),
		'hideDays'        => absint( $settings['hide_days'] ),
		'popupImage'      => esc_url( $settings['popup_image'] ),
		'overlayColor'    => esc_attr( $settings['overlay_color'] ),
		'overlayOpacity'  => floatval( $settings['overlay_opacity'] ),
		'textColor'       => esc_attr( $settings['text_color'] ),
		'disableDate'     => esc_attr( $settings['disable_date'] ),
		'ajaxUrl'         => admin_url( 'admin-ajax.php' ),
		'nonce'           => wp_create_nonce( 'cpp_nonce' ),
	] );
}
add_action( 'wp_enqueue_scripts', 'cpp_enqueue_assets' );

