<?php
/**
 * Plugin Name: Christmas Pop-Up Pro
 * Plugin URI: https://bbrewtech.com/
 * Description: Lightweight Christmas pop-up with full admin customization
 * Version: 1.0.0
 * Author: ByteBrew Technologies
 * Text Domain: cpp
 * Requires at least: 5.0
 * Requires PHP: 7.2
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants
define( 'CPP_VERSION', '1.0.0' );
define( 'CPP_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'CPP_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'CPP_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

// Include required files
require_once CPP_PLUGIN_DIR . 'includes/class-settings.php';
require_once CPP_PLUGIN_DIR . 'includes/class-sanitize.php';
require_once CPP_PLUGIN_DIR . 'includes/class-css.php';
require_once CPP_PLUGIN_DIR . 'includes/class-assets.php';
require_once CPP_PLUGIN_DIR . 'includes/class-ajax.php';
require_once CPP_PLUGIN_DIR . 'includes/class-preview.php';

// Register activation hook
register_activation_hook( __FILE__, 'cpp_activate' );

/**
 * Initialize admin
 */
function cpp_admin_init() {
	if ( is_admin() ) {
		require_once CPP_PLUGIN_DIR . 'admin-page.php';
	}
}
add_action( 'plugins_loaded', 'cpp_admin_init' );
