<?php
/**
 * Admin Settings Page
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Add admin menu
 */
function cpp_add_admin_menu() {
	add_options_page(
		__( 'Christmas Pop-Up', 'cpp' ),
		__( 'Christmas Pop-Up', 'cpp' ),
		'manage_options',
		'christmas-pop-up',
		'cpp_render_admin_page'
	);
}
add_action( 'admin_menu', 'cpp_add_admin_menu' );

/**
 * Enqueue admin assets
 */
function cpp_enqueue_admin_assets( $hook ) {
	if ( 'settings_page_christmas-pop-up' !== $hook ) {
		return;
	}
	
	wp_enqueue_style( 'wp-color-picker' );
	wp_enqueue_script( 'wp-color-picker' );
	wp_enqueue_media(); // For WordPress Media Library
	
	wp_enqueue_script( 'cpp-admin', CPP_PLUGIN_URL . 'assets/cpp-admin.js', [ 'jquery', 'wp-color-picker', 'media-upload', 'media-views' ], CPP_VERSION, true );
	wp_localize_script( 'cpp-admin', 'cppAdmin', [
		'ajaxUrl' => admin_url( 'admin-ajax.php' ),
		'nonce'   => wp_create_nonce( 'cpp_admin_nonce' ),
	] );
	
	wp_add_inline_style( 'wp-admin', '
		.cpp-admin-wrap { max-width: 1200px; margin: 20px 20px 0 0; }
		.cpp-admin-section { background: #fff; padding: 20px; margin-bottom: 20px; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04); }
		.cpp-admin-section h2 { margin-top: 0; border-bottom: 1px solid #eee; padding-bottom: 10px; }
		.cpp-form-group { margin-bottom: 15px; }
		.cpp-form-group label { display: block; font-weight: 600; margin-bottom: 5px; }
		.cpp-form-group input[type="text"],
		.cpp-form-group input[type="number"],
		.cpp-form-group input[type="datetime-local"],
		.cpp-form-group input[type="range"],
		.cpp-form-group textarea { width: 100%; max-width: 500px; }
		.cpp-form-group input[type="range"] { margin-bottom: 5px; }
		#accent_blur_value { font-weight: bold; color: #2271b1; }
		.cpp-form-group textarea { min-height: 80px; }
		.cpp-preview-container { background: #f5f5f5; padding: 20px; border: 1px solid #ddd; min-height: 400px; }
		.cpp-preview-iframe { width: 100%; height: 500px; border: none; background: #fff; }
		.cpp-btn { padding: 8px 16px; background: #2271b1; color: #fff; border: none; cursor: pointer; border-radius: 3px; }
		.cpp-btn:hover { background: #135e96; }
		.cpp-btn-reset { background: #d63638; }
		.cpp-btn-reset:hover { background: #b32d2e; }
		.cpp-success { background: #00a32a; color: #fff; padding: 10px; margin: 10px 0; border-radius: 3px; }
		.cpp-error { background: #d63638; color: #fff; padding: 10px; margin: 10px 0; border-radius: 3px; }
	' );
}
add_action( 'admin_enqueue_scripts', 'cpp_enqueue_admin_assets' );

/**
 * Render admin page
 */
function cpp_render_admin_page() {
	$settings = cpp_get_settings();
	?>
	<div class="wrap cpp-admin-wrap">
		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
		
		<div id="cpp-message"></div>
		
		<form id="cpp-settings-form">
			<?php wp_nonce_field( 'cpp_admin_nonce', 'cpp_nonce' ); ?>
			
			<!-- Text & Labels Section -->
			<div class="cpp-admin-section">
				<h2><?php esc_html_e( 'Text & Labels', 'cpp' ); ?></h2>
				
				<div class="cpp-form-group">
					<label for="headline"><?php esc_html_e( 'Headline', 'cpp' ); ?></label>
					<input type="text" id="headline" name="headline" value="<?php echo esc_attr( $settings['headline'] ); ?>" />
				</div>
				
				<div class="cpp-form-group">
					<label for="subheadline"><?php esc_html_e( 'Sub-headline', 'cpp' ); ?></label>
					<input type="text" id="subheadline" name="subheadline" value="<?php echo esc_attr( $settings['subheadline'] ); ?>" />
				</div>
				
				<div class="cpp-form-group">
					<label for="main_line"><?php esc_html_e( 'Main Line (bold)', 'cpp' ); ?></label>
					<textarea id="main_line" name="main_line"><?php echo esc_textarea( $settings['main_line'] ); ?></textarea>
				</div>
				
				<div class="cpp-form-group">
					<label for="support_line"><?php esc_html_e( 'Support Line', 'cpp' ); ?></label>
					<textarea id="support_line" name="support_line"><?php echo esc_textarea( $settings['support_line'] ); ?></textarea>
				</div>
				
				<div class="cpp-form-group">
					<label for="primary_cta"><?php esc_html_e( 'Primary CTA Button', 'cpp' ); ?></label>
					<input type="text" id="primary_cta" name="primary_cta" value="<?php echo esc_attr( $settings['primary_cta'] ); ?>" />
				</div>
				
				<div class="cpp-form-group">
					<label for="secondary_cta"><?php esc_html_e( 'Secondary CTA Button', 'cpp' ); ?></label>
					<input type="text" id="secondary_cta" name="secondary_cta" value="<?php echo esc_attr( $settings['secondary_cta'] ); ?>" />
				</div>
			</div>
			
			<!-- Colours Section -->
			<div class="cpp-admin-section">
				<h2><?php esc_html_e( 'Colours', 'cpp' ); ?></h2>
				
				<div class="cpp-form-group">
					<label for="bg_grad_start"><?php esc_html_e( 'Background Gradient Start', 'cpp' ); ?></label>
					<input type="text" id="bg_grad_start" name="bg_grad_start" value="<?php echo esc_attr( $settings['bg_grad_start'] ); ?>" class="cpp-color-picker" />
				</div>
				
				<div class="cpp-form-group">
					<label for="bg_grad_end"><?php esc_html_e( 'Background Gradient End', 'cpp' ); ?></label>
					<input type="text" id="bg_grad_end" name="bg_grad_end" value="<?php echo esc_attr( $settings['bg_grad_end'] ); ?>" class="cpp-color-picker" />
				</div>
				
				<div class="cpp-form-group">
					<label for="text_color"><?php esc_html_e( 'Text Color', 'cpp' ); ?></label>
					<input type="text" id="text_color" name="text_color" value="<?php echo esc_attr( $settings['text_color'] ); ?>" class="cpp-color-picker" />
					<p class="description"><?php esc_html_e( 'Color for all text elements (headline, subheadline, main line, support line)', 'cpp' ); ?></p>
				</div>
				
				<div class="cpp-form-group">
					<label for="btn_color"><?php esc_html_e( 'Button Color', 'cpp' ); ?></label>
					<input type="text" id="btn_color" name="btn_color" value="<?php echo esc_attr( $settings['btn_color'] ); ?>" class="cpp-color-picker" />
				</div>
				
				<div class="cpp-form-group">
					<label for="btn_hover"><?php esc_html_e( 'Primary Button Hover Background', 'cpp' ); ?></label>
					<input type="text" id="btn_hover" name="btn_hover" value="<?php echo esc_attr( $settings['btn_hover'] ); ?>" class="cpp-color-picker" />
					<p class="description"><?php esc_html_e( 'Background color when hovering over the primary button', 'cpp' ); ?></p>
				</div>
				
				<div class="cpp-form-group">
					<label for="btn_hover_text"><?php esc_html_e( 'Primary Button Hover Text Color', 'cpp' ); ?></label>
					<input type="text" id="btn_hover_text" name="btn_hover_text" value="<?php echo esc_attr( $settings['btn_hover_text'] ); ?>" class="cpp-color-picker" />
					<p class="description"><?php esc_html_e( 'Text color when hovering over the primary button', 'cpp' ); ?></p>
				</div>
				
				<div class="cpp-form-group">
					<label for="btn_secondary_hover_bg"><?php esc_html_e( 'Secondary Button Hover Background', 'cpp' ); ?></label>
					<input type="text" id="btn_secondary_hover_bg" name="btn_secondary_hover_bg" value="<?php echo esc_attr( $settings['btn_secondary_hover_bg'] ); ?>" class="cpp-color-picker" />
					<p class="description"><?php esc_html_e( 'Background color when hovering over the "No Thanks" button (leave empty for transparent)', 'cpp' ); ?></p>
				</div>
			</div>
			
			<!-- Border & Shadow Section -->
			<div class="cpp-admin-section">
				<h2><?php esc_html_e( 'Border & Shadow', 'cpp' ); ?></h2>
				
				<div class="cpp-form-group">
					<label for="border_width"><?php esc_html_e( 'Border Width (px)', 'cpp' ); ?></label>
					<input type="number" id="border_width" name="border_width" value="<?php echo esc_attr( $settings['border_width'] ); ?>" min="0" max="20" />
					<p class="description"><?php esc_html_e( 'Set to 0 to disable border', 'cpp' ); ?></p>
				</div>
				
				<div class="cpp-form-group">
					<label for="border_color"><?php esc_html_e( 'Border Color', 'cpp' ); ?></label>
					<input type="text" id="border_color" name="border_color" value="<?php echo esc_attr( $settings['border_color'] ); ?>" class="cpp-color-picker" />
				</div>
				
				<div class="cpp-form-group">
					<label for="border_style"><?php esc_html_e( 'Border Style', 'cpp' ); ?></label>
					<select id="border_style" name="border_style">
						<option value="solid" <?php selected( $settings['border_style'], 'solid' ); ?>><?php esc_html_e( 'Solid', 'cpp' ); ?></option>
						<option value="dashed" <?php selected( $settings['border_style'], 'dashed' ); ?>><?php esc_html_e( 'Dashed', 'cpp' ); ?></option>
						<option value="dotted" <?php selected( $settings['border_style'], 'dotted' ); ?>><?php esc_html_e( 'Dotted', 'cpp' ); ?></option>
						<option value="double" <?php selected( $settings['border_style'], 'double' ); ?>><?php esc_html_e( 'Double', 'cpp' ); ?></option>
					</select>
				</div>
				
				<div class="cpp-form-group">
					<label for="border_radius"><?php esc_html_e( 'Border Radius (px)', 'cpp' ); ?></label>
					<input type="number" id="border_radius" name="border_radius" value="<?php echo esc_attr( $settings['border_radius'] ); ?>" min="0" max="50" />
				</div>
				
				<div class="cpp-form-group">
					<label for="shadow_color"><?php esc_html_e( 'Shadow Color', 'cpp' ); ?></label>
					<input type="text" id="shadow_color" name="shadow_color" value="<?php echo esc_attr( $settings['shadow_color'] ); ?>" class="cpp-color-picker" />
					<p class="description"><?php esc_html_e( 'Use rgba format for transparency (e.g., rgba(0, 0, 0, 0.3))', 'cpp' ); ?></p>
				</div>
				
				<div class="cpp-form-group">
					<label for="shadow_x"><?php esc_html_e( 'Shadow X Offset (px)', 'cpp' ); ?></label>
					<input type="number" id="shadow_x" name="shadow_x" value="<?php echo esc_attr( $settings['shadow_x'] ); ?>" min="-50" max="50" />
				</div>
				
				<div class="cpp-form-group">
					<label for="shadow_y"><?php esc_html_e( 'Shadow Y Offset (px)', 'cpp' ); ?></label>
					<input type="number" id="shadow_y" name="shadow_y" value="<?php echo esc_attr( $settings['shadow_y'] ); ?>" min="-50" max="50" />
				</div>
				
				<div class="cpp-form-group">
					<label for="shadow_blur"><?php esc_html_e( 'Shadow Blur (px)', 'cpp' ); ?></label>
					<input type="number" id="shadow_blur" name="shadow_blur" value="<?php echo esc_attr( $settings['shadow_blur'] ); ?>" min="0" max="100" />
				</div>
				
				<div class="cpp-form-group">
					<label for="shadow_spread"><?php esc_html_e( 'Shadow Spread (px)', 'cpp' ); ?></label>
					<input type="number" id="shadow_spread" name="shadow_spread" value="<?php echo esc_attr( $settings['shadow_spread'] ); ?>" min="-50" max="50" />
				</div>
			</div>
			
			<!-- Popup Image Section -->
			<div class="cpp-admin-section">
				<h2><?php esc_html_e( 'Popup Background Image', 'cpp' ); ?></h2>
				
				<div class="cpp-form-group">
					<label for="popup_image"><?php esc_html_e( 'Background Image', 'cpp' ); ?></label>
					<div style="margin-bottom: 10px;">
						<input type="hidden" id="popup_image" name="popup_image" value="<?php echo esc_attr( $settings['popup_image'] ); ?>" />
						<button type="button" id="cpp-upload-image-btn" class="cpp-btn" style="margin-right: 10px;"><?php esc_html_e( 'Select Image', 'cpp' ); ?></button>
						<button type="button" id="cpp-remove-image-btn" class="cpp-btn cpp-btn-reset" style="display: <?php echo ! empty( $settings['popup_image'] ) ? 'inline-block' : 'none'; ?>;"><?php esc_html_e( 'Remove Image', 'cpp' ); ?></button>
					</div>
					<div id="cpp-image-preview" style="margin-top: 10px;">
						<?php if ( ! empty( $settings['popup_image'] ) ) : ?>
							<img src="<?php echo esc_url( $settings['popup_image'] ); ?>" style="max-width: 300px; height: auto; border: 1px solid #ddd; padding: 5px; background: #fff;" />
						<?php endif; ?>
					</div>
					<p class="description"><?php esc_html_e( 'Upload an image from WordPress Media Library to use as popup background', 'cpp' ); ?></p>
				</div>
				
				<div class="cpp-form-group">
					<label for="overlay_color"><?php esc_html_e( 'Overlay Color', 'cpp' ); ?></label>
					<input type="text" id="overlay_color" name="overlay_color" value="<?php echo esc_attr( $settings['overlay_color'] ); ?>" class="cpp-color-picker" />
					<p class="description"><?php esc_html_e( 'Color of the overlay that appears on top of the background image to ensure text visibility', 'cpp' ); ?></p>
				</div>
				
				<div class="cpp-form-group">
					<label for="overlay_opacity"><?php esc_html_e( 'Overlay Opacity (0-1)', 'cpp' ); ?></label>
					<input type="number" id="overlay_opacity" name="overlay_opacity" value="<?php echo esc_attr( $settings['overlay_opacity'] ); ?>" min="0" max="1" step="0.05" style="width: 150px;" />
					<p class="description"><?php esc_html_e( 'Adjust overlay opacity: 0 = transparent (image fully visible), 1 = opaque (image hidden). Recommended: 0.6-0.8 for good text visibility', 'cpp' ); ?></p>
				</div>
			</div>
			
			<!-- Timing Section -->
			<div class="cpp-admin-section">
				<h2><?php esc_html_e( 'Timing', 'cpp' ); ?></h2>
				<p class="description" style="margin-bottom: 15px;"><?php esc_html_e( 'Configure how long the popup should stay hidden after user clicks "No Thanks" or closes the popup', 'cpp' ); ?></p>
				
				<div class="cpp-form-group">
					<label for="hide_mins"><?php esc_html_e( 'Re-open after user closes - Minutes', 'cpp' ); ?></label>
					<input type="number" id="hide_mins" name="hide_mins" value="<?php echo esc_attr( $settings['hide_mins'] ); ?>" min="0" />
				</div>
				
				<div class="cpp-form-group">
					<label for="hide_hours"><?php esc_html_e( 'Re-open after user closes - Hours', 'cpp' ); ?></label>
					<input type="number" id="hide_hours" name="hide_hours" value="<?php echo esc_attr( $settings['hide_hours'] ); ?>" min="0" />
				</div>
				
				<div class="cpp-form-group">
					<label for="hide_days"><?php esc_html_e( 'Re-open after user closes - Days', 'cpp' ); ?></label>
					<input type="number" id="hide_days" name="hide_days" value="<?php echo esc_attr( $settings['hide_days'] ); ?>" min="0" />
				</div>
			</div>
			
			<!-- Button Links Section -->
			<div class="cpp-admin-section">
				<h2><?php esc_html_e( 'Button Links', 'cpp' ); ?></h2>
				
				<div class="cpp-form-group">
					<label for="primary_url"><?php esc_html_e( 'Primary CTA URL', 'cpp' ); ?></label>
					<input type="text" id="primary_url" name="primary_url" value="<?php echo esc_attr( $settings['primary_url'] ); ?>" />
				</div>
			</div>
			
			<!-- Trigger Section -->
			<div class="cpp-admin-section">
				<h2><?php esc_html_e( 'Trigger', 'cpp' ); ?></h2>
				
				<div class="cpp-form-group">
					<label for="delay_seconds"><?php esc_html_e( 'Delay (seconds)', 'cpp' ); ?></label>
					<input type="number" id="delay_seconds" name="delay_seconds" value="<?php echo esc_attr( $settings['delay_seconds'] ); ?>" min="0" />
					<p class="description"><?php esc_html_e( 'Set to 0 to disable delay trigger', 'cpp' ); ?></p>
				</div>
				
				<div class="cpp-form-group">
					<label>
						<input type="checkbox" id="exit_intent" name="exit_intent" value="1" <?php checked( $settings['exit_intent'], 1 ); ?> />
						<?php esc_html_e( 'Enable exit-intent (desktop)', 'cpp' ); ?>
					</label>
				</div>
				
				<div class="cpp-form-group">
					<label>
						<input type="checkbox" id="mobile_disable" name="mobile_disable" value="1" <?php checked( $settings['mobile_disable'], 1 ); ?> />
						<?php esc_html_e( 'Disable on mobile', 'cpp' ); ?>
					</label>
				</div>
				
				<div class="cpp-form-group">
					<label for="cookie_days"><?php esc_html_e( 'Frequency cookie days', 'cpp' ); ?></label>
					<input type="number" id="cookie_days" name="cookie_days" value="<?php echo esc_attr( $settings['cookie_days'] ); ?>" min="0" />
				</div>
			</div>
			
			<!-- Schedule Section -->
			<div class="cpp-admin-section">
				<h2><?php esc_html_e( 'Schedule', 'cpp' ); ?></h2>
				
				<div class="cpp-form-group">
					<label for="disable_date"><?php esc_html_e( 'Auto-disable date & time', 'cpp' ); ?></label>
					<?php 
					$disable_timestamp = strtotime( $settings['disable_date'] );
					$disable_formatted = $disable_timestamp !== false ? date( 'Y-m-d\TH:i', $disable_timestamp ) : date( 'Y-m-d\TH:i', current_time( 'timestamp' ) );
					?>
					<input type="datetime-local" id="disable_date" name="disable_date" value="<?php echo esc_attr( $disable_formatted ); ?>" />
				</div>
			</div>
			
			<!-- Live Preview Section -->
			<div class="cpp-admin-section">
				<h2><?php esc_html_e( 'Live Preview', 'cpp' ); ?></h2>
				<div class="cpp-preview-container">
					<iframe id="cpp-preview-iframe" class="cpp-preview-iframe" src="about:blank"></iframe>
				</div>
			</div>
			
			<!-- Actions -->
			<div class="cpp-admin-section">
				<button type="button" id="cpp-save-btn" class="cpp-btn"><?php esc_html_e( 'Save Settings', 'cpp' ); ?></button>
				<button type="button" id="cpp-reset-btn" class="cpp-btn cpp-btn-reset"><?php esc_html_e( 'Restore Plugin Defaults', 'cpp' ); ?></button>
			</div>
		</form>
	</div>
	<?php
}

