<?php
/**
 * Sanitization Functions
 *
 * @package ChristmasPopUpPro
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Sanitize setting value based on field type
 */
function cpp_sanitize_setting( $key, $value ) {
	$text_fields = [ 'headline', 'subheadline', 'main_line', 'support_line', 'primary_cta', 'secondary_cta', 'primary_url', 'accent_position', 'overlay_color', 'border_color', 'shadow_color', 'border_style' ];
	$int_fields = [ 'accent_enable', 'accent_size', 'accent_blur', 'delay_seconds', 'exit_intent', 'mobile_disable', 'cookie_days', 'hide_mins', 'hide_hours', 'hide_days', 'border_width', 'border_radius', 'shadow_blur', 'shadow_spread', 'shadow_x', 'shadow_y' ];
	$float_fields = [ 'accent_opacity', 'overlay_opacity' ];
	$hex_fields = [ 'bg_grad_start', 'bg_grad_end', 'text_color', 'btn_color', 'btn_hover', 'btn_hover_text', 'btn_secondary_hover_bg' ];
	
	if ( in_array( $key, $text_fields, true ) ) {
		return sanitize_text_field( wp_unslash( $value ) );
	}
	
	if ( in_array( $key, $int_fields, true ) ) {
		return absint( $value );
	}
	
	if ( in_array( $key, $float_fields, true ) ) {
		return floatval( $value );
	}
	
	if ( in_array( $key, $hex_fields, true ) ) {
		return sanitize_hex_color( wp_unslash( $value ) );
	}
	
	if ( 'popup_image' === $key ) {
		return esc_url_raw( wp_unslash( $value ) );
	}
	
	if ( 'disable_date' === $key ) {
		$date_value = sanitize_text_field( wp_unslash( $value ) );
		if ( ! empty( $date_value ) ) {
			$timestamp = strtotime( $date_value );
			if ( $timestamp !== false ) {
				return date( 'Y-m-d H:i', $timestamp );
			}
		}
		return '';
	}
	
	return sanitize_text_field( wp_unslash( $value ) );
}
