<?php
/**
 * Preview Generation Functions
 *
 * @package ChristmasPopUpPro
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Generate preview HTML
 */
function cpp_generate_preview_html( $settings ) {
	$text_color = esc_attr( $settings['text_color'] );
	$btn_color = esc_attr( $settings['btn_color'] );
	$btn_hover = esc_attr( $settings['btn_hover'] );
	$btn_hover_text = isset( $settings['btn_hover_text'] ) ? esc_attr( $settings['btn_hover_text'] ) : '#ffffff';
	$btn_secondary_hover_bg = isset( $settings['btn_secondary_hover_bg'] ) ? esc_attr( $settings['btn_secondary_hover_bg'] ) : '';
	
	$modal_bg = cpp_generate_modal_bg_css( $settings );
	$border_css = cpp_generate_border_css( $settings );
	$shadow_css = cpp_generate_shadow_css( $settings );
	$accent_css = cpp_generate_accent_css( $settings );
	
	// Secondary button hover background
	$secondary_hover_bg = '';
	if ( ! empty( $btn_secondary_hover_bg ) ) {
		$secondary_hover_bg = "background-color: {$btn_secondary_hover_bg};";
	}
	
	$html = '<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Preview - Christmas Pop-Up</title>
	<style>
		* { margin: 0; padding: 0; box-sizing: border-box; }
		body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif; background: #f5f5f5; padding: 20px; }
		.cpp-overlay { position: relative; width: 100%; height: 100vh; background: rgba(0, 0, 0, 0.5); backdrop-filter: blur(8px); -webkit-backdrop-filter: blur(8px); display: flex; align-items: center; justify-content: center; }
		.cpp-modal { position: relative; max-width: 500px; width: 90%; padding: 40px 30px; ' . $modal_bg . ' ' . $border_css . ' ' . $shadow_css . ' }
		' . $accent_css . '
		.cpp-content,
		.cpp-headline,
		.cpp-subheadline,
		.cpp-main-line,
		.cpp-support-line { text-align: center; color: ' . $text_color . '; }
		.cpp-btn-secondary { color: ' . $text_color . '; border-color: ' . $text_color . '; }
		.cpp-headline { font-size: 32px; font-weight: bold; margin: 0 0 10px 0; line-height: 1.2; }
		.cpp-subheadline { font-size: 18px; margin: 0 0 20px 0; opacity: 0.9; }
		.cpp-main-line { font-size: 20px; font-weight: bold; margin: 0 0 15px 0; line-height: 1.4; }
		.cpp-support-line { font-size: 16px; margin: 0 0 30px 0; opacity: 0.85; line-height: 1.5; }
		.cpp-buttons { display: flex; gap: 15px; justify-content: center; flex-wrap: wrap; }
		.cpp-btn { padding: 12px 30px; border: none; border-radius: 6px; font-size: 16px; font-weight: 600; cursor: pointer; text-decoration: none; display: inline-block; }
		.cpp-btn-primary { background-color: ' . $btn_color . '; color: #ffffff; }
		.cpp-btn-primary:hover { background-color: ' . $btn_hover . '; color: ' . $btn_hover_text . '; }
		.cpp-btn-secondary { background: transparent; color: ' . $text_color . '; border: 2px solid ' . $text_color . '; opacity: 0.8; }
		.cpp-btn-secondary:hover { opacity: 1; ' . $secondary_hover_bg . ' }
	</style>
</head>
<body>
	<div class="cpp-overlay">
		<div class="cpp-modal">
			<div class="cpp-content">
				<h2 class="cpp-headline">' . esc_html( $settings['headline'] ) . '</h2>
				<p class="cpp-subheadline">' . esc_html( $settings['subheadline'] ) . '</p>
				<p class="cpp-main-line">' . esc_html( $settings['main_line'] ) . '</p>
				<p class="cpp-support-line">' . esc_html( $settings['support_line'] ) . '</p>
				<div class="cpp-buttons">
					<a href="' . esc_url( $settings['primary_url'] ) . '" class="cpp-btn cpp-btn-primary">' . esc_html( $settings['primary_cta'] ) . '</a>
					<button type="button" class="cpp-btn cpp-btn-secondary">' . esc_html( $settings['secondary_cta'] ) . '</button>
				</div>
			</div>
		</div>
	</div>
</body>
</html>';
	
	return $html;
}

