<?php
/**
 * AJAX Handlers
 *
 * @package ChristmasPopUpPro
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * AJAX: Save settings
 */
function cpp_ajax_save_settings() {
	check_ajax_referer( 'cpp_admin_nonce', 'nonce' );
	
	if ( ! current_user_can( 'manage_options' ) ) {
		wp_send_json_error( [ 'message' => __( 'Insufficient permissions', 'cpp' ) ] );
	}
	
	$defaults = cpp_get_defaults();
	$new_settings = [];
	
	foreach ( $defaults as $key => $default_value ) {
		if ( isset( $_POST[ $key ] ) ) {
			$new_settings[ $key ] = cpp_sanitize_setting( $key, $_POST[ $key ] );
			if ( 'disable_date' === $key && empty( $new_settings[ $key ] ) ) {
				$new_settings[ $key ] = $default_value;
			}
		} else {
			$new_settings[ $key ] = $default_value;
		}
	}
	
	update_option( 'cpp_settings', $new_settings );
	wp_send_json_success( [ 'message' => __( 'Settings saved successfully', 'cpp' ) ] );
}
add_action( 'wp_ajax_cpp_save_settings', 'cpp_ajax_save_settings' );

/**
 * AJAX: Reset to defaults
 */
function cpp_ajax_reset_defaults() {
	check_ajax_referer( 'cpp_admin_nonce', 'nonce' );
	
	if ( ! current_user_can( 'manage_options' ) ) {
		wp_send_json_error( [ 'message' => __( 'Insufficient permissions', 'cpp' ) ] );
	}
	
	$defaults = cpp_get_defaults();
	update_option( 'cpp_settings', $defaults );
	
	wp_send_json_success( [
		'message' => __( 'Settings reset to defaults', 'cpp' ),
		'settings' => $defaults,
	] );
}
add_action( 'wp_ajax_cpp_reset_defaults', 'cpp_ajax_reset_defaults' );

/**
 * AJAX: Get preview HTML
 */
function cpp_ajax_get_preview() {
	check_ajax_referer( 'cpp_admin_nonce', 'nonce' );
	
	if ( ! current_user_can( 'manage_options' ) ) {
		wp_send_json_error( [ 'message' => __( 'Insufficient permissions', 'cpp' ) ] );
	}
	
	$settings = cpp_get_settings();
	$html = cpp_generate_preview_html( $settings );
	
	wp_send_json_success( [ 'html' => $html ] );
}
add_action( 'wp_ajax_cpp_get_preview', 'cpp_ajax_get_preview' );

